@extends('Admin.Layouts.master')
<meta name="csrf-token" content="{{ csrf_token() }}" />
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif



        <div style="display: none;" id="responseBadge" class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-success"></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>


        <div style="display: none;" id="responseBadgefail" class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-danger">

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>



        <h6 class="mb-0 text-uppercase">{{ $clientname[0] }}</h6>
        <hr />

        <div id="renderTable" class="table-responsive">


            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Report Type</th>
                        <th>Slug</th>
                        <th>Mode</th>
                        <th>Mode Management</th>

                        <th>Column Permissions</th>
                        <th>Row Permissions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($reports as $rpt)
                    <tr>
                        <td>{{ $num }}</td>
                        <td> {{ $rpt->report_type }} </td>
                        <td> {{ $rpt->slug_url }} </td>

                        <td>

                            <?php echo ($rpt->status == 1 ? '<label class="text-success">Enabled</label>' : '<label class="text-danger">Disabled</label>'); ?>
                        </td>

                        <td>
                            @if($rpt->status == 0)
                            <form action="{{ route('web.updatepermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->id}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->id }}" name="status" class="js-switch" {{ $rpt->status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-success" for="flexSwitchCheckChecked">ENABLE</label>

                                </div>
                            </form>
                            @else
                            <form action="{{ route('web.updatepermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->id}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->id }}" name="status" class="js-switch" {{ $rpt->status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-danger" for="flexSwitchCheckChecked">DISABLE</label>

                                </div>
                            </form>
                            @endif
                        </td>


                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <div class="col">
                                    <a href="{{ route('web.managecolumnpermissions',[$rpt->slug_url, Crypt::encrypt($clientID) ])}}" type="button" class="btn btn-primary px-5">Manage</a>
                                </div>

                            </div>
                        </td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <div class="col">
                                    <a href="{{ route('web.managerowpermissions',[$rpt->slug_url, Crypt::encrypt($clientID) ])}}" type="button" class="btn btn-primary px-5">Manage</a>
                                </div>

                            </div>
                        </td>

                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


    </div>
</div>

<script>
    $(document).ready(function() {

        let elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));

        elems.forEach(function(html) {
            let switchery = new Switchery(html, {
                size: 'small'
            });
        });


        $('.js-switch').change(function() {

            let status = $(this).prop('checked') === true ? 1 : 0;
            let userId = $(this).data('id');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('users.update.status') }}",
                data: {
                    'status': status,
                    'user_id': userId
                },
                success: function(data) {

                    if (data.message == "true") {

                        document.getElementById('responseBadge').style.display = "block";
                        $('#responseMessage').text("Status updated successfully");
                        updateData();

                    } else {
                        document.getElementById('responseBadgefail').style.display = "block";
                        $('#responseMessage').text("Something went wrong");
                        updateData();
                    }

                }
            });
        });


        function updateData() {

            let clientId = "{{ $clientID }}";

            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('web.managePermissionsajax') }}",
                data: {
                    'client' : clientId
                },
                success: function(data) {


                    $('#renderTable').html('');
                    $('#renderTable').html(data);



                }
            });
        }

    });
</script>
@endsection