@extends('Admin.Layouts.master')
<?php

use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
@section('content')

<div class="card">
    <div class="card-body" id="photo">

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <h6 class="mb-0 text-uppercase text-center text-danger"> {{ $clientname[0] }} </h6>
        <p class="text-center"> {{ $location[0] }} , {{ $area[0] }} </p>
        <p class="text-center">
            <?php echo "SALE REPORT FROM " . (MainAcontroller::convertDate($from)) ?> TO <?php echo (MainAcontroller::convertDate($to)) ?>
            <br>
        </p>

        <div class="showSaleDetail" id="showSaleDetail">

            @if(session('LoggedUser')['userRole'] == "shop")

            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Total Sale</p>
                                    <h4 id="S1_TotalSale" class="mb-0 text-primary">Rs. <?php echo ($totalsale[0]['totalsale']) ?>
                                    </h4>
                                </div>
                                <div class="ms-auto fs-2 text-primary">
                                    <i class="fadeIn animated bx bx-store"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span></span></small> -->
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Average Sale</p>
                                    <h4 id="S1_AvgSale" class="mb-0 text-danger">Rs. {{ number_format( (float)($totalsale[0]['totalsale']) / $count ,2) }} </h4>
                                    <!-- <h4 class="mb-0 text-danger">Rs. {{  GeneralController::daysInDate($from,$to) }} </h4> -->
                                </div>
                                <div class="ms-auto fs-2 text-danger">
                                    <i class="fadeIn animated bx bx-rupee"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span>+10.5% from last week</span></small> -->
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Previous Month Average Sale</p>
                                    @foreach( $avgsale as $avg )
                                    <h4 id="S1_AvgSale" class="mb-0 text-success">Rs. {{ number_format( $avg->nsum,2) }} </h4>
                                    @endforeach <!-- <h4 class="mb-0 text-danger">Rs. {{  GeneralController::daysInDate($from,$to) }} </h4> -->
                                </div>
                                <div class="ms-auto fs-2 text-danger">
                                    <i class="fadeIn animated bx bx-rupee"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span>+10.5% from last week</span></small> -->
                        </div>
                    </div>
                </div>


            </div>


            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">

                <div class="col">
                    <div class="card radius-10 border-0 border-start border-tiffany border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Cash</p>
                                    @foreach($cashsale as $ca)
                                    <h4 id="S1_CashSale" class="mb-0 text-tiffany">Rs. {{ number_format( $ca->cash ,2) }}</h4>
                                    @endforeach
                                </div>
                                <div class="ms-auto widget-icon bg-tiffany text-white">
                                    <i class="fadeIn animated bx bx-money"></i>
                                </div>
                            </div>

                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'cash',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                            <!-- <hr class="my-2">
                            <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a> -->
                        </div>
                    </div>
                </div>

                <!-- <div onclick="showWarning()" style="opacity: 0.5;" class="col">
                    <div class="card radius-10 border-0 border-start border-tiffany border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Cash</p>
                                    <h4 class="mb-0 text-tiffany">Rs. ---------- </h4>
                                </div>
                                <div class="ms-auto widget-icon bg-tiffany text-white">
                                    <i class="fadeIn animated bx bx-money"></i>
                                </div>
                            </div>
                            <hr class="my-2">
                            <a><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        </div>
                    </div>
                </div> -->

                <div class="col">
                    <div class="card radius-10 border-0 border-start border-success border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Credit</p>

                                    @foreach($creditsale as $ca)
                                    <h4 id="S1_CreditSale" class="mb-0 text-success">Rs. {{ number_format($ca->credit,2) }}</h4>
                                    @endforeach
                                </div>
                                <div class="ms-auto widget-icon bg-success text-white">
                                    <i class="fadeIn animated bx bx-book-alt"></i>
                                </div>
                            </div>
                            @if($permissions[0]['s1_isCreditclick'] != 0)
                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'credit',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                            @else
                            <hr class="my-2">
                            <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- <div onclick="showWarning()" style="opacity: 0.5;" class="col">
                    <div class="card radius-10 border-0 border-start border-success border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Credit</p>
                                    <h4 class="mb-0 text-success">Rs. ---------- </h4>
                                </div>
                                <div class="ms-auto widget-icon bg-success text-white">
                                    <i class="fadeIn animated bx bx-book-alt"></i>
                                </div>
                            </div>

                            <hr class="my-2">
                            <a><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        </div>
                    </div>
                </div> -->

                <div class="col">
                    <div class="card radius-10 border-0 border-start border-pink border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Card</p>
                                    @foreach($cardsale as $ca)
                                    <h4 id="S1_CardSale" class="mb-0 text-pink">Rs. {{ number_format($ca->card,2) }}</h4>
                                    @endforeach

                                </div>
                                <div class="ms-auto widget-icon bg-pink text-white">
                                    <i class="fadeIn animated bx bx-wallet-alt"></i>
                                </div>
                            </div>
                            @if($permissions[0]['s1_isCardclick'] != 0)
                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'card',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                            @else
                            <hr class="my-2">
                            <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>

                            @endif

                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Bill Total Count</p>
                                    <h4 id="S1_BillCount" class="mb-0 text-pink">{{ $billCount[0]['billCount'] }}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-pink">
                                    <i class="fadeIn animated bx bx-repeat"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div onclick="showWarning()" class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Bill Total Count</p>
                                    <h4 class="mb-0 text-pink">----------</h4>
                                </div>
                                <div class="ms-auto fs-2 text-pink">
                                    <i class="fadeIn animated bx bx-repeat"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->


                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Starting Bill No</p>
                                    <h4 id="S1_StartBill" class="mb-0 text-info"> # {{ $startBill[0]['startBill']}}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-info">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div onclick="showWarning()" class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Starting Bill No</p>
                                    <h4 class="mb-0 text-info"> ---------- </h4>
                                </div>
                                <div class="ms-auto fs-2 text-info">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Ending Bill No</p>
                                    <h4 id="S1_EndBill" class="mb-0 text-purple"> # {{ $endBill[0]['endBill']}}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-purple">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div onclick="showWarning()" class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Ending Bill No</p>
                                    <h4 class="mb-0 text-purple"> ---------- </h4>
                                </div>
                                <div class="ms-auto fs-2 text-purple">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->
            </div>

            <a href="{{ route('web.viewSaleReportTwo',[Crypt::encrypt($from),Crypt::encrypt($to),Crypt::encrypt($client)]) }}" style="float: center;" class="btn btn-primary">View Details</a>
            <!-- <a onclick="showWarning()" style="float: center;" class="btn btn-primary">View Details</a> -->

            @else

            <!-- admin view -->

            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Total Sale</p>
                                    <h4 id="S1_TotalSale" class="mb-0 text-primary">Rs. {{ number_format((float) $totalsale[0]['totalsale'],2) }}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-primary">
                                    <i class="fadeIn animated bx bx-store"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span></span></small> -->
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Average Sale</p>
                                    <h4 id="S1_AvgSale" class="mb-0 text-danger">Rs. {{ number_format( (float)($totalsale[0]['totalsale']) / $count ,2) }} </h4>
                                    <!-- <h4 class="mb-0 text-danger">Rs. {{  GeneralController::daysInDate($from,$to) }} </h4> -->
                                </div>
                                <div class="ms-auto fs-2 text-danger">
                                    <i class="fadeIn animated bx bx-rupee"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span>+10.5% from last week</span></small> -->
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Previous Month Average Sale</p>
                                    @foreach( $avgsale as $avg )
                                    <h4 id="S1_AvgSale" class="mb-0 text-success">Rs. {{ number_format( $avg->nsum,2) }} </h4>
                                    @endforeach
                                    <!-- <h4 class="mb-0 text-danger">Rs. {{  GeneralController::daysInDate($from,$to) }} </h4> -->
                                </div>
                                <div class="ms-auto fs-2 text-success">
                                    <i class="fadeIn animated bx bx-rupee"></i>
                                </div>
                            </div>
                            <!-- <hr class="my-2"> -->
                            <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span>+10.5% from last week</span></small> -->
                        </div>
                    </div>
                </div>

            </div>

            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
                <div class="col">
                    <div class="card radius-10 border-0 border-start border-tiffany border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Cash</p>
                                    @foreach($cashsale as $ca)
                                    <h4 id="S1_CashSale" class="mb-0 text-tiffany">Rs. {{ number_format( $ca->cash ,2) }}</h4>
                                    @endforeach
                                </div>
                                <div class="ms-auto widget-icon bg-tiffany text-white">
                                    <i class="fadeIn animated bx bx-money"></i>
                                </div>
                            </div>
                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'cash',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card radius-10 border-0 border-start border-success border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Credit</p>
                                    @foreach($creditsale as $ca)
                                    <h4 id="S1_CreditSale" class="mb-0 text-success">Rs. {{ number_format($ca->credit,2) }}</h4>
                                    @endforeach
                                </div>
                                <div class="ms-auto widget-icon bg-success text-white">
                                    <i class="fadeIn animated bx bx-book-alt"></i>
                                </div>
                            </div>
                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'credit',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>

                        </div>
                    </div>
                </div>


                <div class="col">
                    <div class="card radius-10 border-0 border-start border-pink border-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Card</p>
                                    @foreach($cardsale as $ca)
                                    <h4 id="S1_CardSale" class="mb-0 text-pink">Rs. {{ number_format($ca->card,2) }}</h4>
                                    @endforeach
                                </div>
                                <div class="ms-auto widget-icon bg-pink text-white">
                                    <i class="fadeIn animated bx bx-wallet-alt"></i>
                                </div>
                            </div>
                            <hr class="my-2">
                            <a href="{{ route('web.viewTypeDetails',[$from,$to,'card',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Bill Total Count</p>
                                    <h4 id="S1_BillCount" class="mb-0 text-pink">{{ $billCount[0]['billCount'] }}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-pink">
                                    <i class="fadeIn animated bx bx-repeat"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Starting Bill No</p>
                                    <h4 id="S1_StartBill" class="mb-0 text-info"> # {{ $startBill[0]['startBill']}}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-info">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="">
                                    <p class="mb-1">Ending Bill No</p>
                                    <h4 id="S1_EndBill" class="mb-0 text-purple"> # {{ $endBill[0]['endBill']}}</h4>
                                </div>
                                <div class="ms-auto fs-2 text-purple">
                                    <i class="fadeIn animated bx bx-book-open"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <a href="{{ route('web.viewSaleReportTwo',[Crypt::encrypt($from),Crypt::encrypt($to),Crypt::encrypt($client)]) }}" style="float: center;" class="btn btn-primary">View Details</a>

            @endif

        </div>


    </div>
</div>

<script>
    $(document).ready(function() {

        $.ajax({
            type: "GET",
            dataType: "json",
            url: "{{ route('web.getAllClients') }}",

            success: function(data) {

                $("#bannerSelectShops").empty();

                $('#bannerSelectShops')
                    .append($("<option></option>")
                        .attr("value", "")
                        .text("Choose one"));

                $.each(data, function(index, value) {

                    $('#bannerSelectShops')
                        .append($("<option></option>")
                            .attr("value", value.ClientID)
                            .text(value.ClientName + "|" + value.ClientID + "|" + value.Area + "|" + value.Location))

                });

            }
        });


        // $(".searchSale").click(function() {

        //     document.getElementById("saleSearchForm").style.display = "none";
        //     document.getElementById("showSaleDetail").style.display = "block";


        // });




        var frm = $('#frm_saleActivityOne');

        frm.submit(function(e) {

            e.preventDefault();

            alert('submitted');

            // new ajax
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "{{ route('web.getSaleActivityOne') }}",
                data: {
                    shop: $('#bannerSelectShops').val(),
                    from: $('#b_from').val(),
                    to: $('#b_to').val()
                },
                success: function(data) {

                    alert(data);

                    data.forEach(function(number) {



                    });
                }
            });
            // new ajax close

        });




    });
</script>

@endsection