@extends('Admin.Layouts.master')

<title> <?php echo $clientname[0] . " \n " . $area[0] . " \n " . $location[0] . " \n SALE REPORT FROM " . $from . " to " . $to ?> </title>


<?php

use App\Http\Controllers\MainAcontroller; ?>

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center text-danger"> {{ $clientname[0] }} </h6>
        <p class="text-center"> {{ $location[0] }} , {{ $area[0] }} </p>
        <p class="text-center">
            <?php echo "SALE REPORT FROM " . (MainAcontroller::convertDate($from)) ?> TO <?php echo (MainAcontroller::convertDate($to)) ?>
            <br>
        </p>
        <br>

        @if(session('LoggedUser')['userRole'] == "shop")


        @if($permissions[0]['s2_isTotalSale'] != 0)
        <h6 class="mb-0 text-uppercase text-center">TOTAL SALE : {{ $overallSale[0]['overallSale'] }}</h6>
        <h6 class="mb-0 text-uppercase text-center">AVG SALE : {{ $overallSale[0]['overallSale'] / $count }}</h6>
        @else
        <h6 onclick="showWarning()" class="mb-0 text-uppercase text-center">TOTAL SALE : -------------- </h6>
        <h6 onclick="showWarning()" class="mb-0 text-uppercase text-center">AVG SALE : ---------------- </h6>
        @endif
        <hr />

        <div id="renderTable" class="table-responsive">

            <table data-page-length='20' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th style="text-align: center;">Sl No</th>
                        <th style="text-align: center;">Bill Date</th>
                        <th style="text-align: center;">Bill Count</th>
                        <th style="text-align: center;">Start Bill</th>
                        <th style="text-align: center;">End Bill</th>
                        <th style="text-align: right;">Sale Amount</th>
                        <th style="text-align: center;">Sale Summary</th>
                        @if($permissions[0]['s2_isViewMore'] != 0)
                        <th style="text-align: center;">Action</th>
                        @else
                        <th onclick="showWarning()" style="text-align: center; opacity: 0.5;">Action</th>
                        @endif
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($totalsale as $sale)
                    <tr>
                        <td style="text-align: center;">{{ $num }}</td>

                        <td style="text-align: center;">
                            <?php echo (MainAcontroller::convertDate($sale->bill_date)) ?>
                            <br>
                            <label class="text-danger"> <?php echo (MainAcontroller::findDay(MainAcontroller::convertDate($sale->bill_date)))  ?> </label>
                        </td>


                        <td style="text-align: center;"> {{ $sale->billcount }} </td>
                        <td style="text-align: center;"> {{ $sale->first }}  </td>
                        <td style="text-align: center;"> {{ $sale->last }} </td>
                        <td style="text-align: right;"> {{ $sale->totalSale }} </td>

                        @if( $sale->totalSale < $overallSale[0]['overallSale'] / $count ) <!-- <td style="text-align: center;"> <label class="text-danger"> LOW </label> </td> -->
                            <td style="text-align: center;"> <label class="text-danger"> {{ number_format(($overallSale[0]['overallSale'] / $count) - $sale->totalSale,2)   }} <i class="fadeIn animated bx bx-downvote"></i> </label> </td>

                            @elseif($sale->totalSale > $overallSale[0]['overallSale'] / $count )
                            <!-- <td style="text-align: center;"> <label class="text-success"> HIGH </label> </td> -->

                            <td style="text-align: center;"> <label class="text-success"> {{ number_format( $sale->totalSale - ($overallSale[0]['overallSale'] / $count) ,2)   }} <i class="fadeIn animated bx bx-upvote"></i> </label> </td>


                            @endif



                            @if($permissions[0]['s2_isViewMore'] != 0)
                            <td style="text-align: center;">
                                <a href="{{ route('web.viewSaleReportThree',[$sale->bill_date,$sale->bill_date,$client]) }}" class="btn btn-primary">View more</a>
                            </td>
                            @else
                            <td style="text-align: center;">
                                <a onclick="showWarning()" class="btn btn-primary">View more</a>
                            </td>
                            @endif
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


        @else


        <h6 class="mb-0 text-uppercase text-center">TOTAL SALE : {{ $overallSale[0]['overallSale'] }}</h6>
        <h6 class="mb-0 text-uppercase text-center">AVG SALE : {{ $overallSale[0]['overallSale'] / $count }}</h6>
        <hr />

        <div id="renderTable" class="table-responsive">

            <table data-page-length='20' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th style="text-align: center;">Sl No</th>
                        <th style="text-align: center;">Bill Date</th>
                        <th style="text-align: center;">Bill Count</th>
                        <th style="text-align: center;">Start Bill</th>
                        <th style="text-align: center;">End Bill</th>
                        <th style="text-align: right;">Sale Amount</th>
                        <th style="text-align: center;">Sale Summary</th>
                        <th style="text-align: center;">Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($totalsale as $sale)
                    <tr>
                        <td style="text-align: center;">{{ $num }}</td>

                        <td style="text-align: center;">
                            <?php echo (MainAcontroller::convertDate($sale->bill_date)) ?>
                            <br>
                            <label class="text-danger"> <?php echo (MainAcontroller::findDay(MainAcontroller::convertDate($sale->bill_date)))  ?> </label>
                        </td>


                        <td style="text-align: center;"> {{ $sale->billcount }} </td>
                        <td style="text-align: center;"> {{ $sale->first }}  </td>
                        <td style="text-align: center;"> {{ $sale->last }} </td>
                        <td style="text-align: right;"> {{ $sale->totalSale }} </td>

                        @if( $sale->totalSale < $overallSale[0]['overallSale'] / $count ) <!-- <td style="text-align: center;"> <label class="text-danger"> LOW </label> </td> -->
                            <td style="text-align: center;"> <label class="text-danger"> {{ number_format(($overallSale[0]['overallSale'] / $count) - $sale->totalSale,2)   }} <i class="fadeIn animated bx bx-downvote"></i> </label> </td>

                            @elseif($sale->totalSale > $overallSale[0]['overallSale'] / $count )
                            <!-- <td style="text-align: center;"> <label class="text-success"> HIGH </label> </td> -->

                            <td style="text-align: center;"> <label class="text-success"> {{ number_format( $sale->totalSale - ($overallSale[0]['overallSale'] / $count) ,2)   }} <i class="fadeIn animated bx bx-upvote"></i> </label> </td>


                            @endif

                            <td style="text-align: center;">
                                <a href="{{ route('web.viewSaleReportThree',[$sale->bill_date,$sale->bill_date,$client]) }}" class="btn btn-primary">View more</a>
                            </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


        @endif





    </div>
</div>



<script>
    // let status = 0;
    $(document).ready(function() {

        $('#exampleONE').DataTable({
            dom: 'Bfrtip',

            buttons: [{
                extend: 'pdf',
                exportOptions: {
                    columns: [0, 1, 2, 3]
                },
                customize: function(doc) {

                    doc.styles.message.alignment = "right";

                    doc.content[1].table.widths = ['25%', '25%', '25%', '25%'];

                    var rowCount = doc.content[1].table.body.length;

                    doc.content[1].table.body[0][3].alignment = 'right';

                    for (i = 1; i < rowCount; i++) {

                        doc.content[1].table.body[i][0].alignment = 'center';
                        doc.content[1].table.body[i][1].alignment = 'center';
                        doc.content[1].table.body[i][2].alignment = 'center';
                        doc.content[1].table.body[i][3].alignment = 'right';

                        // doc.content[1].table.body[i][3].alignment = 'right';
                        // doc.content[1].table.body[i][3].text += ' €';
                    };

                }


            }, {
                extend: 'excel',
                text: 'Excel',
                exportOptions: {

                    modifier: {
                        page: 'all'
                    }
                }
            }]
        });
    });
</script>

@endsection