@extends('Admin.Layouts.master')
<meta name="csrf-token" content="{{ csrf_token() }}" />
<!-- <title>{{ $clientname[0] }} <br> {{ $from}} to {{ $to }} Total Bill Count - {{ $billCount[0]['billcount'] }}</title> -->

<title>  <?php echo $clientname[0] ."\n". $type . " SALES FROM ".$from." to ".$to. " TOTAL BILL COUNT : ".$billCount[0]['billcount'] ;?>     </title>
<?php use App\Http\Controllers\MainAcontroller;?>
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h5 class="mb-0 text-uppercase text-center text-danger"> {{ $clientname[0] }} </h5>
        <h6 class="mb-0 text-uppercase text-center"> {{ $type }} SALE FROM <?php echo ((MainAcontroller::convertDate($from)))?> to <?php echo ((MainAcontroller::convertDate($to)))?> </h6>
        <br>
        <h6 class="mb-0 text-uppercase text-center"> Total Sale : {{ $totalsale[0]['saleamount'] }} </h6>
        <br>
        <h6 class="mb-0 text-uppercase text-center"> Total Bill Count {{ $billCount[0]['billcount'] }} </h6>
        <hr/>

        <div id="" class="table-responsive">

            <table data-page-length='30' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th style="text-align: center;">Bill No</th>
                        <th style="text-align: right;">Amount</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($typeSale as $sale)
                    <tr>
                        <td>{{ $num }}</td>
                        <td style="text-align: center;"> {{ $sale->bill_no }} </td>
                        <td align="right"> {{ number_format($sale->amount, 2) }} </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


    </div>
</div>

<script>
    let status = 0;
    $(document).ready(function() {
        
        $('#exampleONE').DataTable({
            dom: 'Bfrtip',

            buttons: [{
                extend: 'pdf',
                customize: function(doc) {

                    doc.styles.message.alignment = "right";

                    doc.content[1].table.widths = ['33.33%', '33.33%', '33.33%'];

                    var rowCount = doc.content[1].table.body.length;

                    doc.content[1].table.body[0][2].alignment = 'right';

                    for (i = 1; i < rowCount; i++) {
                        doc.content[1].table.body[i][0].alignment = 'center';
                        doc.content[1].table.body[i][1].alignment = 'center';
                        doc.content[1].table.body[i][2].alignment = 'right';
                        // doc.content[1].table.body[i][3].alignment = 'right';
                        // doc.content[1].table.body[i][3].text += ' €';
                    };

                }
            }, {
                extend: 'excel',
                text: 'Excel',
                exportOptions: {
                    modifier: {
                        page: 'all'
                    }
                }
            }]
        });
    });
</script>

@endsection