@extends('Admin.Layouts.master')

@section('content')
<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Upload Payment QR</h5>
            </div>
            <hr />

            <form method="post" action="{{ route('web.uploadQRImage') }}" enctype="multipart/form-data">
                @csrf

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Payment QR Image</label>
                    <div class="col-sm-9">
                        <input name="banner" type="file" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                @if($status == 0)
                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5">Upload</button>
                    </div>
                </div>
                @else

                <label class="text-danger"> * you have already uploaded one contact admin to change existing payment QR </label>

                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button disabled type="submit" class="btn btn-primary px-5">Upload</button>
                    </div>
                </div>
                @endif




            </form>

        </div>





    </div>
</div>

@endsection