<meta name="csrf-token" content="{{ csrf_token() }}" />

@extends('Admin.Layouts.master')
<?php

use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
@section('content')

<div class="card">
    <div class="card-body" id="photo">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <div id="saleSearchForm" class="border p-4 rounded">

            <div class="card-header py-3">
                <div class="row g-3 align-items-center">

                    <div class="col-12 col-lg-4 col-md-6 me-auto">
                        <h5 class="mb-0 ">{{ $cliName }} , {{ $Area }} , {{ $Location }} </h5>
                    </div>
                </div>



                <div class="mt-2">
                    <p>User : {{ $userName }} , Package : {{ $Package }}</p>

                    <?php $billing_type = MainAcontroller::getBillingTypeForUser($userid) ?>

                    @if($billing_type != '' && $billing_type == 'M')
                    <label class="text-danger">Monthly Billing</label>
                    @else
                    <label class="text-danger">Yearly Billing</label>
                    @endif

                </div>
            </div>

            <br>

            <h5>Log Report</h5>
            <div class="table-responsive mt-5">
                <!-- data-page-length='10' id="" class="table table-striped table-bordered" -->
                <table id="example" class="display" style="width:100%">
                    <thead class="table-secondary">
                        <tr>
                            <!-- <th>#</th> -->
                            <th>Sl No</th>
                            <th>Type</th>
                            <th>Package</th>
                            <th>From Date</th>
                            <th>To Date</th>
                            <th>Allotted Date</th>
                            <th>Remark</th>

                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>

                    <tbody>
                        <?php $num = 1; ?>

                        @foreach( $history as $per )
                        <tr>

                            <!-- <td> <input type="checkbox" name="permissions[]" id="permissionCheck"> </td> -->
                            <td> {{ $num }} </td>
                            <td> {{ $per->Type }} </td>
                            <td> {{ $Package }} </td>
                            <td> <?php echo MainAcontroller::convertDate($per->From_Date)?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->To_Date)?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->AllottedDate)?> </td>
                 
                            <td> {{ $per->remarks }} </td>
                        </tr>
                        <?php $num++; ?>
                        @endforeach


                    </tbody>
                </table>
            </div>

            <br>

            <h5>Payment History</h5>
            <div class="table-responsive mt-5">
                <!-- data-page-length='10' id="" class="table table-striped table-bordered" -->
                <table id="" class="table table-striped table-bordered">
                    <thead class="table-secondary">
                        <tr>
                            <!-- <th>#</th> -->
                            <th>Sl No</th>
                            <th>Order Date</th>
                            <th>From Date</th>
                            <th>To Date</th> 
                            <th>Trans. Type</th>
                            <th align="right">Actual Amount</th>
                            <th align="right">Adjustment</th>
                            <th align="right">Paid Amount</th>
                            <th align="right">Remark</th>

                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>


                    <tbody>
                        <?php $num = 1; ?>

                        @foreach( $payment as $per )
                        <tr>
                            <td> {{ $num }} </td>
                            <td> <?php echo MainAcontroller::convertDate($per->Order_Date)?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->Effect_From)?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->Effect_To)?> </td>
               
                            <td> {{ $per->Trans_Type }} </td>
                            <td align="right"> Rs. <?php echo number_format($per->actualAmount,2) ?> </td>
                            <td align="right"> Rs. <?php echo number_format( str_replace("-","",$per->adjustmentAmount),2) ?> </td>
                            <td align="right"> Rs. <?php echo number_format($per->Order_Amount,2) ?> </td>
                            <td> {{ $per->pay_remark }} </td>

                        </tr>
                        <?php $num++; ?>
                        @endforeach


                    </tbody>
                </table>
            </div>



        </div>


    </div>
</div>



<!-- popup dialogue for from and to -->
<div class="modal fade" id="modelEnablePermission" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Copy Permission</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- updatePermissionStatusWithFromTo -->

            <form method="post" action="{{ route('web.readytopaycopy')}}" class="row g-3">
                @csrf
                <div class="modal-body">

                    <div class="modal-body">

                        <input hidden id="copytid" required name="tid" type="text" class="form-control">
                        <input hidden value=" " id="copymarchantid" required name="merchant_id" type="text" class="form-control">
                        <input hidden value=" " id="copyorderid" required name="order_id" type="text" class="form-control">
                        <input hidden value="INR" id="currency" required name="currency" type="text" class="form-control">
                        <input hidden value="https://api.digitronicsindia.com/medisoft/public/uploads/ccavResponseHandler.blade.php" id="redirect_url" required name="redirect_url" type="text" class="form-control">
                        <input hidden value="https://api.digitronicsindia.com/medisoft/public" id="cancel_url" required name="cancel_url" type="text" class="form-control">
                        <input hidden value="EN" id="language" required name="language" type="text" class="form-control">

                        <label>Billing Address</label>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_name" type="text" name="billing_name" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_address" type="text" name="billing_address" value=" " />
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_city" type="text" name="billing_city" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_state" type="text" name="billing_state" value="KERALA" />
                            </div>
                        </div>
                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_zip" type="text" name="billing_zip" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" type="text" name="billing_country" value="India" />
                            </div>
                        </div>

                        <br>
                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_tel" type="text" name="billing_tel" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_email" type="text" name="billing_email" value=" " />
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">

                            <div class="col-6">
                                <label class="form-label">Amount</label>
                                <input id="copyamount" readonly required name="amount" type="text" class="form-control">
                            </div>

                            <div class="col-6">
                                <label class="form-label">Amount (Adjustment + or - ) </label>
                                <input id="copyamount" name="adjustment" type="number" pattern="{0-9}[5]" class="form-control">
                            </div>

                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <label class="form-label">Client</label>
                                <input readonly id="copym1" required name="merchant_param1" type="text" class="form-control">
                            </div>

                            <div class="col-6">
                                <label class="form-label">User ID</label>
                                <select id="copym2" required name="merchant_param2" class="form-control">
                                </select>
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-4">
                                <label class="form-label">From Date</label>
                                <input min="<?php echo date('Y-m-d'); ?>" id="copym3" required name="merchant_param3" type="date" class="form-control">
                            </div>

                            <div class="col-4">
                                <label class="form-label">No Of Days</label>
                                <input id="daysCount" required name="daysCount" type="number" class="form-control daysCount">
                            </div>

                            <div class="col-4">
                                <label class="form-label">To Date</label>
                                <input min="<?php echo date('Y-m-d'); ?>" id="copym4" required name="merchant_param4" type="date" class="form-control">
                            </div>
                        </div>


                        <div hidden class="col-12">
                            <label class="form-label">Type</label>
                            <input id="copym5" required name="merchant_param5" value="copy" type="text" class="form-control">
                        </div>

                        <br>


                        <div class="col-12">
                            <input id="cistrial" name="cistrial" type="checkbox">
                            <label class="form-label">Trial Version</label>
                        </div>


                        <div class="col-12">
                            <input checked id="cisActive" name="cisActive" type="checkbox">
                            <label for="isActive" class="form-label">Skip the payment and make the pack active</label>
                        </div>

                    </div>



                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Permission</button>

                    </div>

                </div>
            </form>

        </div>
    </div>
</div>



@endsection