<?php

use App\Http\Controllers\ClientController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProductController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Route::apiResource('generateCashClosingBill', ClientController::class);

Route::get('/getliability/{client}/{user}/{from}/{to}', [ProductController::class, 'getliability']);

Route::get('/expirydemo/{clientid}/{from}/{to}/{supplier}/{userid}', [ProductController::class, 'expirydemo']);

//  in use
Route::get('/getExpiry/{clientid}/{from}/{to}/{supplier}/{userid}', [ProductController::class, 'getExpiry']);

//  in use
Route::get('/getClosing/{BillNo}/{clientID}/{userid}', [ClientController::class, 'generateBillApi']);

//  in use
Route::get('/purchaseorderpdf/{ordernumber}/{clientid}/{userid}', [ClientController::class, 'getpurchaseorderpdf']);

//  in use
Route::get('/purchaseorderminipdf/{ordernumber}/{clientid}/{userid}', [ClientController::class, 'purchaseorderminipdf']);

//  in use
Route::get('/stockreportdownload/{clientid}/{userid}', [ClientController::class, 'stockreportdownload']);

//  in use
Route::get('/purchaseorderexcel/{ordernumber}/{clientid}/{userid}', [ClientController::class, 'exportUsers']);


Route::get('/successpay', [PaymentController::class, 'successpay']);

