
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>



        <div style="display: none;" id="responseBadge" class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-success"></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>


        <div style="display: none;" id="responseBadgefail" class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-danger">

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>



        <h6 class="mb-0 text-uppercase"><?php echo e($clientname[0]); ?></h6>
        <hr />

        <div id="renderTable" class="table-responsive">


            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Report Type</th>
                        <th>Slug</th>
                        <th>Mode</th>
                        <th>Mode Management</th>

                        <th>Column Permissions</th>
                        <th>Row Permissions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rpt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($num); ?></td>
                        <td> <?php echo e($rpt->report_type); ?> </td>
                        <td> <?php echo e($rpt->slug_url); ?> </td>

                        <td>

                            <?php echo ($rpt->status == 1 ? '<label class="text-success">Enabled</label>' : '<label class="text-danger">Disabled</label>'); ?>
                        </td>

                        <td>
                            <?php if($rpt->status == 0): ?>
                            <form action="<?php echo e(route('web.updatepermissions')); ?>" method="post" id="toggleForm">
                                <?php echo csrf_field(); ?>
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="<?php echo e($rpt->id); ?>">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="<?php echo e($rpt->id); ?>" name="status" class="js-switch" <?php echo e($rpt->status == 1 ? 'checked' : ''); ?>>

                                    <label class="form-check-label text-success" for="flexSwitchCheckChecked">ENABLE</label>

                                </div>
                            </form>
                            <?php else: ?>
                            <form action="<?php echo e(route('web.updatepermissions')); ?>" method="post" id="toggleForm">
                                <?php echo csrf_field(); ?>
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="<?php echo e($rpt->id); ?>">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="<?php echo e($rpt->id); ?>" name="status" class="js-switch" <?php echo e($rpt->status == 1 ? 'checked' : ''); ?>>

                                    <label class="form-check-label text-danger" for="flexSwitchCheckChecked">DISABLE</label>

                                </div>
                            </form>
                            <?php endif; ?>
                        </td>


                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <div class="col">
                                    <a href="<?php echo e(route('web.managecolumnpermissions',[$rpt->slug_url, Crypt::encrypt($clientID) ])); ?>" type="button" class="btn btn-primary px-5">Manage</a>
                                </div>

                            </div>
                        </td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <div class="col">
                                    <a href="<?php echo e(route('web.managerowpermissions',[$rpt->slug_url, Crypt::encrypt($clientID) ])); ?>" type="button" class="btn btn-primary px-5">Manage</a>
                                </div>

                            </div>
                        </td>

                    </tr>

                    <?php $num++; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>


        </div>


    </div>
</div>

<script>
    $(document).ready(function() {

        let elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));

        elems.forEach(function(html) {
            let switchery = new Switchery(html, {
                size: 'small'
            });
        });


        $('.js-switch').change(function() {

            let status = $(this).prop('checked') === true ? 1 : 0;
            let userId = $(this).data('id');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: "<?php echo e(route('users.update.status')); ?>",
                data: {
                    'status': status,
                    'user_id': userId
                },
                success: function(data) {

                    if (data.message == "true") {

                        document.getElementById('responseBadge').style.display = "block";
                        $('#responseMessage').text("Status updated successfully");
                        updateData();

                    } else {
                        document.getElementById('responseBadgefail').style.display = "block";
                        $('#responseMessage').text("Something went wrong");
                        updateData();
                    }

                }
            });
        });


        function updateData() {

            let clientId = "<?php echo e($clientID); ?>";

            $.ajax({
                type: "GET",
                dataType: "json",
                url: "<?php echo e(route('web.managePermissionsajax')); ?>",
                data: {
                    'client' : clientId
                },
                success: function(data) {


                    $('#renderTable').html('');
                    $('#renderTable').html(data);



                }
            });
        }

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/managepermissions.blade.php ENDPATH**/ ?>