

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Users</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('web.createnewuser',Crypt::encrypt($cid))); ?>" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i> Create User </a>
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Shop</th>
                        <th>Client ID</th>
                        <th>Package Status</th>
                        <th>Package Expiry</th>
                        <th>Account Type</th>
                        <th>Managed Shops</th>
                        <th>App Status</th>
                        <th>Web Status</th>

                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($num); ?></td>

                        <td>
                            <?php if($client->IsLive == 1): ?>
                            <span class="badge bg-success">Live Pack</span>
                            <?php elseif($client->IsLive == 0): ?>
                            <span class="badge bg-danger">Trial Pack</span>
                            <?php endif; ?>

                            <?php if($client->is_demo == 1): ?>
                            <span class="badge bg-danger">Demo Account</span>
                            <?php elseif($client->is_demo == 0): ?>
                            <span class="badge bg-success">Main Account</span>
                            <?php endif; ?>

                            <?php if($client->is_MultiUser == 'S'): ?>
                            <span class="badge bg-danger"> Single User </span>
                            <?php elseif($client->is_MultiUser == 'M'): ?>
                            <span class="badge bg-info"> Multi User </span>
                            <?php elseif($client->is_MultiUser == 'SM'): ?>
                            <span class="badge bg-success"> Single and Multi User </span>
                            <?php endif; ?>

                            <br>
                            <?php echo e($client->Name); ?>

                            <br>

                            <label class="text-success"> <?php if($client->billing_type == 'Y'): ?> Yearly Billing <?php elseif($client->billing_type == 'M'): ?> Monthly Billing <?php endif; ?> </label>



                        </td>
                        <td><?php echo e($client->UserName); ?></td>

                        <td><?php echo e($client->ClientName); ?>

                            <p> <?php echo e($client->Area); ?> </p>
                            <p> <?php echo e($client->Location); ?></p>
                            <br>
                            
                        </td>

                        <td> <label class="text-danger"> <?php echo e($client->userid); ?> </label></td>

                        <!-- <td><?php echo e($client->Mobile); ?></td> -->

                        <?php if($client->IsLive == 2): ?>

                        <td align="center"> <label style="color: red;"> No Active Pack </label> </td>

                        <?php elseif( $client->IsLive == 1 ): ?>

                        <td align="center"> <label style="color: green;">Active Pack</label> <br>

                            <a href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>" class="btn alert-success radius-30 px-4"> <label> <?php echo MainAcontroller::getFromDateForTrial($client->id) ?> to <?php echo MainAcontroller::getToDateForTrial($client->id) ?></label> </a>

                        </td>

                        <?php else: ?>
                        <td align="center"> <label style="color: blue;">Trial</label> <br>

                            <a href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>" class="btn alert-info radius-30 px-4"> <label><?php echo MainAcontroller::getFromDateForTrial($client->id) ?> to <?php echo MainAcontroller::getToDateForTrial($client->id) ?></label> </a>

                        </td>
                        <?php endif; ?>

                        <?php if($client->per_to != null || $client->per_to != '' ): ?>
                        <td>
                            <?php if( GeneralController::daysleft($client->per_to) == 'Date is Expired' ): ?>
                            <a href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">
                                <label class="btn btn-danger"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            <?php else: ?>

                            <?php if($client->IsLive == 1): ?>
                            <a href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">
                                <label class="btn btn-success"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            <?php elseif($client->IsLive == 0): ?>
                            <a href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">
                                <label class="btn btn-info"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            <?php endif; ?>

                            <?php endif; ?>


                        </td>
                        <?php else: ?>
                        <td> <label class="text-danger">Not Found</label> </td>
                        <?php endif; ?>

                        <?php if($client->IsUser == 1): ?>
                        <td> <label style="color: green;">USER</label> </td>
                        <?php elseif( $client->IsShop == 1 ): ?>
                        <td> <label style="color: green;">SHOP</label> </td>
                        <?php else: ?>
                        <td> <label style="color: green;">ADMIN</label> </td>
                        <?php endif; ?>

                        <td> <?php echo GeneralController::managedShopList($client->UserName) ?> </td>

                        <?php if($client->Active == 1): ?>
                        <td> <label style="color: green;">Active</label> </td>
                        <?php else: ?>
                        <td> <label style="color: red;">Inactive</label> </td>
                        <?php endif; ?>

                        <?php if($client->isWebLogin == 1): ?>
                        <td> <label style="color: green;">Active</label> </td>
                        <?php else: ?>
                        <td> <label style="color: red;">Inactive</label> </td>
                        <?php endif; ?>

                        <td>

                            <?php if( $client->IsUser == 1 || $client->IsShop == 1 || $client->IsStaff == 1 || $client->Admin == 1 ): ?>

                            <div class="col">
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Actions</button>
                                    <ul class="dropdown-menu">

                                        <?php if($client->Active == 1): ?>
                                        <li><a class="dropdown-item text-danger" href="<?php echo e(route('web.updateAppLoginStatus',Crypt::encrypt($client->id))); ?>">Disable App Login</a>
                                        </li>
                                        <?php else: ?>
                                        <li><a class="dropdown-item text-success" href=" <?php echo e(route('web.updateAppLoginStatus',Crypt::encrypt($client->id))); ?>">Enable App Login</a>
                                        </li>
                                        <?php endif; ?>

                                        <?php if($client->isWebLogin == 1): ?>
                                        <li><a class="dropdown-item text-danger" href="<?php echo e(route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))); ?>">Disable Web Login</a>
                                        </li>
                                        <?php else: ?>
                                        <li><a class="dropdown-item text-success" href="<?php echo e(route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))); ?>">Enable Web Login</a>
                                        </li>
                                        <?php endif; ?>

                                        <!-- <li><a class="dropdown-item" href="<?php echo e(route('web.manageUserPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">Permissions</a>
                                        </li> -->

                                        <!-- <li><a class="dropdown-item" href="<?php echo e(route('web.assignUserPermission',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">Permissions</a>
                                        </li> -->

                                        <?php if($client->isPrimary == 0 && $client->IsShop == 1): ?>

                                        <li><a class="dropdown-item" href="<?php echo e(route('web.makeasprimaryaccount', Crypt::encrypt($client->id) )); ?>"> Make as Primary </a>
                                        </li>

                                        <?php endif; ?>

                                        <?php if($client->isPrimary == 1): ?>

                                        <li>
                                            <a class="dropdown-item" href="<?php echo e(route('web.managesubusers', Crypt::encrypt($client->userid) )); ?>"> Create Sub Users </a>
                                        </li>

                                        <li>
                                            <a style="background: transparent;" data-max="<?php echo e($client->max_connections); ?>" data-id="<?php echo e($client->userid); ?>" data-uid="<?php echo e($client->id); ?>" class="dropdown-item manageMaxConnections" title=""> Manage Max Connections </a>
                                        </li>

                                        <?php endif; ?>

                                        <li><a class="dropdown-item" href="<?php echo e(route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )); ?>">App Permissions</a>
                                        </li>

                                        <li><a class="dropdown-item text-success" href="<?php echo e(route('web.resetpasswordtodefault',Crypt::encrypt($client->id))); ?>">Reset Password to Default</a>
                                        </li>

                                        <li><a class="dropdown-item" href="<?php echo e(route('web.viewPrivilageHistory',Crypt::encrypt($client->id))); ?>">Privilage History</a>
                                        </li>

                                        <li><a data-id="<?php echo e($client->id); ?>" data-name="<?php echo e($client->Name); ?>" data-email="<?php echo e($client->UserName); ?>" data-mobile="<?php echo e($client->Mobile); ?>" class="dropdown-item UpdateUserDetailsModel">Update User Details</a>
                                        </li>

                                        <li><a class="dropdown-item" href="<?php echo e(route('web.enableForceLogout',Crypt::encrypt($client->id))); ?>">Force Logout</a>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                            <?php endif; ?>




                        </td>
                    </tr>
                    <?php $num++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });

        $(".manageMaxConnections").click(function() {

            var clientid = $(this).data("id");
            var userid = $(this).data("uid");
            var max = $(this).data("max");

            document.getElementById("maxConn").value = max;
            document.getElementById("maxclientid").value = clientid;
            document.getElementById("maxuserid").value = userid;

            $('#modalManageMaxConnection').modal('show');

        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/manageShopUsers.blade.php ENDPATH**/ ?>