

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>



        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Banners</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('web.createBanner')); ?>" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i>  Create Banner   </a>
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive mt-3">
            <table class="table align-middle">
                <thead class="table-secondary">
                    <tr>
                        <th>#</th>
                        <th>Client ID</th>
                        <th>Banner</th>
                        <th>Description</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Status</th>
                        <th>Created Date</th>
                        <th>Created By</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $cnt = 1; ?>
                    <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td> <?php echo e($cnt); ?> </td>

                        <td><?php echo e($banner->ClientID); ?></td>
                        
                        <td>
                            <?php $path = 'https://api.digitronicsindia.com/medisoft/public/uploads/banners/' . $banner->ClientID . '/' . $banner->banner_img . '' ?>
                            <div class="d-flex align-items-center gap-3 cursor-pointer">
                                <a class="showImageLarge" data-path="<?php echo $path ?>"> <img src="<?php echo $path ?>" class="rounded-circle" width="44" height="44" alt=""> </a>
                                <div class="">
                                    <p class="mb-0"> </p>
                                </div>
                            </div>
                        </td>
                        
                        <td><?php echo e($banner->banner_desc); ?></td>
                        <td><?php echo e($banner->from_date); ?></td>
                        <td><?php echo e($banner->to_date); ?></td>

                        <?php if($banner->banner_status == 1): ?>
                        <td> <label class="text-success"> Active </label> </td>
                        <?php else: ?>
                        <td> <label class="text-danger"> Inactive </label> </td>
                        <?php endif; ?>

                        <td><?php echo e($banner->created_date); ?></td>
                        <td><?php echo e($banner->created_by); ?></td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">
                                <a href="<?php echo e(route('web.updateBannerStatus',$banner->id)); ?>" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"><i class="bi bi-pencil-fill"></i></a>
                                <a onclick="return confirm('Are you sure want to delete this banner ?')" href="<?php echo e(route('web.deleteBanner',$banner->id)); ?>" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash-fill"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php $cnt++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </tbody>
            </table>
        </div>

    </div>
</div>

<script>
    $(document).ready(function() {

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/manageBanner.blade.php ENDPATH**/ ?>