

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Payment History</div>
        </div>


        <hr />



        <!-- <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">

            <input id="proName" class="form-control" type="text" placeholder="enter names here">
            <input id="proNameID"  class="form-control" type="text" >

        </div> -->

       



        <div class="table-responsive">
        <!-- width="100%" data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%"  >
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Order ID</th>
                        <th> Order Date </th>
                        <th>Client Name</th>
                        <th>Amount</th>
                        <th>Done For</th>
                        <th>Done By</th>
                        <th>Transaction Type</th>
                        <th>From Date</th>
                        <th>To Date</th>


                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    <?php $__currentLoopData = $paymenthistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($num); ?></td>

                        <td> <a href=""><?php echo e($client->Order_ID); ?></a> </td>
                        <td> <?php echo e($client->Order_Date); ?> </td>

                        <td><?php echo e($client->ClientName); ?> <br> <?php echo e($client->Area); ?> <br> <?php echo e($client->Location); ?> </td>

                        <td> Rs .<?php echo number_format($client->Order_Amount,2)?></td>
                        <td><?php echo e($client->donefor); ?></td>
                        <td><?php echo e($client->doneby); ?></td>
                        <td><?php echo e($client->Trans_Type); ?></td>
                        <td><?php echo e($client->Effect_From); ?></td>
                        <td><?php echo e($client->Effect_To); ?></td>

                        <td>Action</td>



                    </tr>
                    <?php $num++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- grant for all model  -->
<div class="modal fade" id="grantForAllModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Grant Privilege For All Clients</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('web.grantPrivilegeForAll')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="col-12">
                        <label class="form-label">From Date</label>
                        <input id="dateFrom" required name="from" type="date" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">To Date</label>
                        <input id="dateFrom" required name="to" type="date" class="form-control">
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        $("#proName").autocomplete({
            source: function(request, response) {

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: "<?php echo e(route('web.getSimilarClients')); ?>",
                    data: {
                        search: request.term
                    },
                    success: function(data) {

                        response($.map(data, function(el) {
                            return {
                                label: el.ClientName,
                                value: el.ClientID
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {

                $('#proName').val(ui.item.label); // display the selected text
                $('#proNameID').val(ui.item.value); // save selected id to input
                return false;

            },
            focus: function(event, ui) {

                $("#proName").val(ui.item.label);
                $("#proNameID").val(ui.item.value);
                return false;

            },
        });

    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/paymenthistory.blade.php ENDPATH**/ ?>