<!DOCTYPE html>
<html>

<head>
    <style>
        .table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .nobdtable {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .td,
        .th {
            border: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .notd {
            border-top: .5px solid white;
            border-bottom: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .box {
            overflow-y: auto;
            height: 800px;
        }

        #watermark {
            position: fixed;
            bottom: 9px;
            right: 9px;
            opacity: 0.4;
            color: black;
            background-color: rgba(131, 50, 185, 0.5);
            height: 40px;
            width: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #myid {
            background-color: azure;
            height: 125px;
        }

        .alignleft {
            float: left;
            font-size: 8px;
        }

        .alignright {
            float: right;
        }

        .alncenter {
            text-align: center;
        }

        .alnleft {
            text-align: right;
        }

        .alnright {
            text-align: right;
        }

        /* .table td {
            font-size: .8em;
        }

        .table th {
            font-size: .8em;
        } */



        /* label { 
            font-size: .8em
        }  */
    </style>
</head>

<body>


    <?php

    use App\Http\Controllers\MainAcontroller;
    use App\Http\Controllers\ProductController; ?>
    <div class="card">
        <div class="card-body">
            <div class="table-responsive box">


                <?php if($demo == 1): ?>
                <center> <span class="alncenter"> DEMO </span></center>
                <center> <span class="alncenter"> Demo , Demo </span></center>
                <?php else: ?>
                <center> <span class="alncenter"> <?php echo e($clientName); ?> </span></center>
                <center> <span class="alncenter"> <?php echo e($clietArea); ?> , <?php echo e($clientLocation); ?> </span></center>
                <?php endif; ?>


                <center> <span class="alncenter"><?php echo e($title); ?></span></center>
                <center> <span class="alncenter">Report generated on : <?php echo date('d-m-Y'); ?></span></center>

                <?php
                $num = 1;
                $totalCost = ProductController::getExpiredProductsSUMByClientID(0, $from, $to, $clientid);
                ?>

                <br>

                <table class="table">

                    <tr>
                        <td class="td" width="5%">SL</td>
                        <td class="td" width="30%">Product Name</td>
                        <td class="td" width="10%">Company</td>
                        <td class="td" width="10%">Batch</td>
                        <td class="td" width="5%">Exp. Dt.</td>
                        <td class="td" width="5%">Pack</td>
                        <td class="td" width="10%">MRP</td>
                        <td class="td" width="5%">Qty</td>
                        <td class="td" width="10%">P. Value</td>
                        <td class="td" width="10%">MRP Value</td>
                    </tr>

                    <?php $__currentLoopData = $expiry; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <tr>
                        <td class="td"><?php echo e($num); ?></td>

                        <td class="td" align="left"><?php echo e($client->product_name); ?> </td>

                        <td class="td" align="left"><?php echo e($client->company_name); ?></td>

                        <td class="td" align="center"><?php echo e($client->batch); ?></td>
                        <td class="td" align="center"> <?php echo MainAcontroller::convertDatetoExpiry($client->expiry) ?> </td>

                        <td class="td" align="center"><?php echo e($client->pack); ?></td>
                        <td class="td" align="center"> <?php echo number_format((float)$client->MRPPack, 2, '.', '') ?> </td>

                        <td class="td" align="center"><?php echo e($client->stkqty); ?></td>

                        <td class="alnright td"> <?php echo number_format((float)$client->PAmt, 2, '.', '') ?> </td>

                        <td class="alnright td"> <?php echo number_format((float)$client->MRPAmt, 2, '.', '') ?> </td>
                    </tr>

                    <?php $num++; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </table>


                <table class="nobdtable">
                    <tr>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="30%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                    </tr>

                    <?php $__currentLoopData = $totalCost; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="8" class="alnleft td"> Total Purchase Amount and MRP Amount </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->pCost, 2, '.', '') ?> </strong> </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->MRPCost, 2, '.', '') ?> </strong> </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>

                <span> Powered by MEDISOFT &#169; 2023</span>


            </div>
        </div>
    </div>



</body>

</html><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/demoexpiry.blade.php ENDPATH**/ ?>