<!-- viewCustomerAppUsers.blade.php -->



<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <hr />

        <h5 class="text-center"><?php echo e($clientname); ?></h5>

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Shop</th>
                        <th>Reg. Date</th>
                        <th>Account Type</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($num); ?></td>

                        <td><?php echo e($client->Name); ?> </td>

                        <td><?php echo e($client->UserName); ?></td>

                        <td>
                            <p><?php echo e($client->userid); ?></p>
                            <p><?php echo e($client->ClientName); ?></p>
                            <p> <?php echo e($client->Area); ?> </p>
                            <p> <?php echo e($client->Location); ?></p>
                        </td>

                        <td> <label class="text-danger"> <?php echo MainAcontroller::convertDate($client->Reg_stamp); ?> </label></td>

                        <!-- <td><?php echo e($client->Mobile); ?></td> -->

                       

                        <?php if($client->IsUser == 1): ?>
                        <td> <label style="color: green;">USER</label> </td>
                        <?php elseif( $client->IsShop == 1 ): ?>
                        <td> <label style="color: green;">SHOP</label> </td>
                        <?php else: ?>
                        <td> <label style="color: green;">ADMIN</label> </td>
                        <?php endif; ?>

                       

                       
                    </tr>
                    <?php $num++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });

        $(".manageMaxConnections").click(function() {

            var clientid = $(this).data("id");
            var userid = $(this).data("uid");
            var max = $(this).data("max");

            document.getElementById("maxConn").value = max;
            document.getElementById("maxclientid").value = clientid;
            document.getElementById("maxuserid").value = userid;

            $('#modalManageMaxConnection').modal('show');

        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/aswas/resources/views/Admin/viewCustomerAppUsers.blade.php ENDPATH**/ ?>